
/*ns to access TPS65070 touch screen chip.
 *
 * Copyright (c) 2009 RidgeRun (todd.fischer@ridgerun.com)
 *
 *
 *  For licencing details see kernel-base/COPYING
 */

#ifndef __LINUX_I2C_TPS6507X_TS_H
#define __LINUX_I2C_TPS6507X_TS_H

#include <linux/ft5x06_i2c_defs.h>
#include <linux/earlysuspend.h>
#include <linux/input/matrix_keypad.h>

#define MAX_KEY_ROWS    5
#define USED_KEY_ROWS   5
#define MAX_KEY_COLS    1
#define USED_KEY_COLS   1
#define MAX_KEY_NUM     (MAX_KEY_ROWS * MAX_KEY_COLS)
#define ROW_SHIFT       3
#define NUM_OF_HARDKEYS 5

extern int g_virt_dbg_keys;  //set default back keys....

/* Board specific touch screen initial values */
struct touchscreen_init_data {
	int	poll_period;	/* ms */
	int	vref;		/* non-zero to leave vref on */
	__u16	min_pressure;	/* min reading to be treated as a touch */
	__u16	vendor;
	__u16	product;
	__u16	version;
};

struct UiHalTouch {
        int touchId;
        int pressState;
        int xPosition;
        int yPosition;
};

struct ft5x06 {
    struct i2c_client *client;
    struct input_dev *input;
    struct input_dev *keyinput;
    struct work_struct work;
    //struct timer_list timer;
    char phys[32];
    struct ft5x06_platform_data *platform_data;
    u8 num_prv_st_tch;
    u16 act_trk[FT_NUM_TRK_ID];
    u16 prv_st_tch[FT_NUM_ST_TCH_ID];
    u16 prv_mt_tch[FT_NUM_MT_TCH_ID];
    u16 prv_mt_pos[FT_NUM_TRK_ID][2];
    u8 crosstalk_test_type;
    u8 factory_mode_register;
    u8 working_mode_register;
    atomic_t irq_enabled;
    /* Ensures that only one function can specify the Device Mode at a time. */
    struct mutex device_mode_mutex;
    struct early_suspend early_suspend;
    struct regulator *vtp;
};

#if 0
struct matrix_keymap_data vButton_keymap_data = {
        .keymap = vButton_matrix_keys,
        .keymap_size = ARRAY_SIZE(vButton_matrix_keys),
};
#endif


#endif /*  __LINUX_I2C_TPS6507X_TS_H */

